/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.handler;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import com.eeeab.eeeabsmobs.sever.entity.impl.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.impl.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.item.util.EEArmorMaterial;
import com.eeeab.eeeabsmobs.sever.item.util.EEArmorUtil;
import com.eeeab.eeeabsmobs.sever.message.MessageVertigoEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public final class HandlerServerEvent {
    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        Raider raider;
        Zombie zombie;
        AbstractGolem abstractGolem;
        AbilityCapability.IAbilityCapability capability;
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player && (capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)entity)) != null) {
            capability.onInit((LivingEntity)entity);
        }
        if (entity instanceof AbstractGolem && !((abstractGolem = (AbstractGolem)entity) instanceof Shulker)) {
            abstractGolem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractGolem, EntityImmortal.class, 5, false, false, null));
        }
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton abstractSkeleton = (AbstractSkeleton)entity;
            abstractSkeleton.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractSkeleton, EntityImmortal.class, 0, true, false, null));
        }
        if (entity instanceof Zombie && !((zombie = (Zombie)entity) instanceof ZombifiedPiglin)) {
            zombie.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)zombie, EntityImmortal.class, 0, true, false, null));
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            villager.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)villager, EntityImmortal.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof Raider && !((raider = (Raider)entity) instanceof SpellcasterIllager)) {
            raider.f_21345_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)raider, EntityImmortal.class, 5, true, false, null));
        }
    }

    @SubscribeEvent
    public void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null) {
            AbilityCapability.IAbilityCapability abilityCapability;
            LivingEntity entity = event.getEntity();
            VertigoCapability.IVertigoCapability vertigoCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (vertigoCapability != null) {
                vertigoCapability.tick(entity);
            }
            if ((abilityCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.CUSTOM_ABILITY_CAPABILITY)) != null) {
                abilityCapability.tick(entity);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onAddPointEffect(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == EffectInit.VERTIGO_EFFECT.get() && !event.getEntity().f_19853_.f_46443_) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Added)event).getEntity()), (Object)new MessageVertigoEffect(event.getEntity(), true));
            VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)event.getEntity(), HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (capability != null) {
                capability.onStart(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onRemovePotionEffect(MobEffectEvent.Remove event) {
        if (!event.getEntity().f_19853_.m_5776_() && event.getEffect() == EffectInit.VERTIGO_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Remove)event).getEntity()), (Object)new MessageVertigoEffect(event.getEntity(), false));
            VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)event.getEntity(), HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (capability != null) {
                capability.onEnd(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onExpirePotionEffect(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().f_19853_.m_5776_() && effectInstance != null && effectInstance.m_19544_() == EffectInit.VERTIGO_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Expired)event).getEntity()), (Object)new MessageVertigoEffect(event.getEntity(), false));
            VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)event.getEntity(), HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (capability != null) {
                capability.onEnd(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity;
        if (event.getEntity() != null && (entity = event.getEntity()).m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get()) && entity.m_20096_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        Player entity = event.getEntity();
        if (event.isCancelable() && entity.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityKnockBack(LivingKnockBackEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living instanceof EntityNamelessGuardian) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityHurt(LivingHurtEvent event) {
        LivingEntity hurtEntity = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (hurtEntity instanceof Player) {
            Player player = (Player)hurtEntity;
            if (attacker instanceof EntityImmortal && EEArmorUtil.checkFullSuitOfArmor(EEArmorMaterial.IMMORTAL_MATERIAL, player)) {
                float damage = event.getAmount();
                damage -= damage * 0.1f;
                event.setAmount(damage);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEntityChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
        if (capability != null && event.isCancelable() && entity instanceof Mob && capability.isVertigo() && (event.getOriginalTarget() != null || entity.m_6274_().m_21874_(MemoryModuleType.f_26372_))) {
            event.setCanceled(true);
        }
    }
}

